using System.Security.Cryptography;

namespace Prijateljski_trkaci
{
    public class Tacka
    {
        public double X { get; set; }
        public double Y { get; set; }
        public Tacka(double x, double y)
        {
            X = x;
            Y = y;
        }
    }
    internal class Program
    {
        public static void UnosPodataka(out int n, out Tacka[] tacke)
        {
            // Unos broja tacaka
            n = int.Parse(Console.ReadLine());

            // Inicijalizacija niza tacaka
            tacke = new Tacka[n];

            // Unos tacaka
            for (int i = 0; i < n; i++)
            {
                double[] input = Array.ConvertAll(Console.ReadLine().Split(' '), double.Parse);
                tacke[i] = new Tacka(input[0], input[1]);
            }
        }

        public static bool JeCeo(double x)
        {
            return Math.Floor(x) == x;
        }

        public static bool SePozdravljaju(double x1, double y1, double x2, double y2)
        {
            return JeCeo(x1) && JeCeo(Math.Abs(y1 - y2) / 2);
        }

        public static int BrojPozdrava(int n, Tacka[] tacke)
        {
            int ukupnoPozdrava = 0;

            // Kada su X ili Y kordinate jednake i celi brojevi
            if (tacke[0].X == tacke[1].X)
            {
                if (SePozdravljaju(tacke[0].X, tacke[0].Y, tacke[1].X, tacke[1].Y)) ukupnoPozdrava++;
            }
            else if (tacke[0].Y == tacke[1].Y)
            {
                if (SePozdravljaju(tacke[0].Y, tacke[0].X, tacke[1].Y, tacke[1].X)) ukupnoPozdrava++;
            }
            else
            {
                // Kada X i Y kordinate nisu jednake, ali jesu celi brojevi
                if (JeCeo(tacke[0].X) && JeCeo(tacke[1].Y)) ukupnoPozdrava++;
                if (JeCeo(tacke[1].X) && JeCeo(tacke[0].Y)) ukupnoPozdrava++;
            }


            return ukupnoPozdrava;
        }

        static void Main(string[] args)
        {
            UnosPodataka(out int n, out Tacka[] tacke);

            Console.WriteLine(BrojPozdrava(n, tacke));
        }
    }
}